<?php

class Ultimate_Ai_Upload_Image_In_Media_Library
{
  function __construct()
  {
    add_action("wp_ajax_ultimate_ai_upload_base64_img", array($this, "ultimate_ai_upload_base64_img"));
  }

  public function ultimate_ai_upload_base64_img()
  {
    if (
      !isset($_POST["name"]) || empty($_POST["name"]) ||
      !isset($_POST["base64_img"]) || empty($_POST["base64_img"]) ||
      !isset($_POST["img_mime_type"]) || empty($_POST["img_mime_type"])
    ) {
      wp_send_json(array("data" => esc_html__("Send proper data", ULTIMATE_AI_SLUG)), 400);
    }

    $base64_img = Ultimate_AI_Filter_Controller($_POST["base64_img"]);
    $name = sanitize_title($_POST["name"]);
    $img_mime_type = sanitize_text_field($_POST["img_mime_type"]);

    $url = $this->upload_base64_file_in_media_library($base64_img, $name, $img_mime_type);

    if ($url) {
      wp_send_json(array("data" => $url), 200);
    } else {
      wp_send_json(array("data" => esc_html__("Image upload fail", ULTIMATE_AI_SLUG)), 400);
    }
  }

  public function upload_base64_file_in_media_library($base64_img, $title, $mime_type)
  {

    if (empty($base64_img)) {
      return "";
    }

    // Upload dir.
    $upload_dir  = wp_upload_dir();
    $upload_path = str_replace('/', DIRECTORY_SEPARATOR, $upload_dir['path']) . DIRECTORY_SEPARATOR;

    $type = 'data:' . $mime_type . ';base64,';

    $img             = str_replace($type, '', $base64_img);
    $img             = str_replace(' ', '+', $img);
    $decoded         = base64_decode($img);
    $filename        = $title . '.' . explode("/", $mime_type)[1];
    $file_type       = $mime_type;
    $hashed_filename = md5($filename . microtime()) . '_' . $filename;

    // Save the image in the uploads directory.
    $upload_file = file_put_contents($upload_path . $hashed_filename, $decoded);

    $attachment = array(
      'post_mime_type' => $file_type,
      'post_title'     => preg_replace('/\.[^.]+$/', '', basename($hashed_filename)),
      'post_content'   => '',
      'post_status'    => 'inherit',
      'guid'           => $upload_dir['url'] . '/' . basename($hashed_filename)
    );

    $attach_id = wp_insert_attachment($attachment, $upload_dir['path'] . '/' . $hashed_filename);

    return wp_get_attachment_url($attach_id);
  }
}


new Ultimate_Ai_Upload_Image_In_Media_Library();
